<?php

namespace App\Imports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Cviebrock\EloquentSluggable\Services\SlugService;

class UsersImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {

        $name = $row['first_name'] . ' ' . $row['last_name'];
        if ($row['dob'] == '') {
            $dob = NULL;
        } else {
            $dob = date("Y-m-d", strtotime($row['dob']));
        }

        $slug = SlugService::createSlug(
            User::class,
            'slug',
            $name
        );


        return new User([
            'VP_ID' => $row['vp_id'],
            'VP_NAME' => $row['vp_name'],
            'UserId' => $row['userid'],
            'Patient_Identification_Number' => $row['patient_identification_number'],
            'First_Name' => $row['first_name'],
            'Last_Name' => $row['last_name'],
            'slug' => $slug,
            'Email' => $row['email'],
            'Phone_Code' => $row['phone_code'],
            'phone' => $row['phone'],
            'sms' => $row['sms'],
            'Gender' => $row['gender'],
            'Weight' => $row['weight'],
            'Height' => $row['height'],
            'DOB' =>  $dob,
            'Blood_Type' => $row['blood_type'],
            'Patient_Status' => $row['patient_status'],
            'Reg_Date' => date("Y-m-d H:i:s", strtotime($row['reg_date'])),
        ]);
    }
}
